# If you don't have Pester installed, run this command
# Install-Module -Name Pester -Force
# This test code is written for PowerShell 5.1, if you're using Version 7, then the syntax will be wrong and you will receive errors
# Output the $PSVersionTable to verify your version of PowerShell

# Unload and reload the module so it will use the latest code
Remove-Module GreetMe -ErrorAction SilentlyContinue
Import-Module GreetMe -Verbose

# Test the module manifest
Describe "Module Manifest" {
    $moduleManifestPath = Join-Path $RootDir "..\GreetMe.psd1"

    # Does the manifest file exist?
    It "Module Manifest Exists" {
        Test-Path $moduleManifestPath | Should Be $true
    }

    # Make sure the manifest file contains the information we want
    It "Is the module manifest valid?" {
        Test-ModuleManifest -Path $moduleManifestPath -ErrorVariable ManifestInvalid -ErrorAction SilentlyContinue
        $ManifestInvalid | Should Be $Null
    }
}

# Test the Get-GreetingMessage function
Describe "Get-GreetingMessage" {
    It "Returns a valid greeting message" {
        $name = "John"
        $greeting = Get-GreetingMessage -Name $name
        $expectedGreeting = "Hello, $name!*"
        $greeting | Should Match $expectedGreeting
    }
}