# Function: Get-GreetingMessage
# Description: Generates a personalized greeting message for a user.
# Parameters:
#   - Name (string): The name of the user.
function Get-GreetingMessage {
# Docs for help contents below:
# https://learn.microsoft.com/en-us/powershell/module/microsoft.powershell.core/about/about_comment_based_help?view=powershell-5.1

    param (
        [Parameter(Mandatory = $true)]
        [string]$Name
    )
    # Get the initial greeting
    $greeting = "Hello, $Name!"

    # Get a random message
    $greetingMessage = New-Greeting

    # Output the messages to the user
    Write-Output "$greeting $greetingMessage"
}
