# Variables
$modulePublicPath = Join-Path $PSScriptRoot "Public"
$modulePrivatePath = Join-Path $PSScriptRoot "Private"

# Import private functions
# These will NOT be exported, which means they are NOT accessible outside the module
Get-ChildItem -Path $modulePrivatePath -Filter "*.ps1" | ForEach-Object {
    # Dot source the file to import its functions
    . $_.FullName
}

# Import and export functions from Public folder
Get-ChildItem -Path $modulePublicPath -Filter "*.ps1" | ForEach-Object {
    # Dot source the file to import its functions
    . $_.FullName

    # Export the functions so they are available outside the module
    Export-ModuleMember -Function $_.BaseName
}