﻿# Prep System.Drawing
[void] [System.Reflection.Assembly]::LoadWithPartialName("System.Drawing") 

# Get the file
$file = Read-Host -Prompt "Type the path to your source heightmap"
$image = [System.Drawing.Image]::FromFile($file)

# File output prefix
$output_prefix = "tile_"

# Output what we are about to do
Write-Host "File prefix: $output_prefix"
Write-Host "Source file: $file"
Write-Host "Image Dimensions: $($image.Width) x $($image.Height)"

# See what dimenion the user wants to use
$tile_x=Read-Host -Prompt "Please enter the width in pixels each tile should be..."
$tile_y=Read-Host -Prompt "Please enter the height in pixels each tile should be..."

# Output how many tiles there will be
Write-Host "There will be" (($image.width / $tile_x) * ($image.height / $tile_y)) " tiles."
Pause

# Starting coordinates
$x_coord=0
$y_coord=0

# Iterate over Y
for ($y_index = 0; $y_index -lt ($image.Height / $tile_y); $y_index++) {

    # Begin iterating over X
    for ($x_index = 0; $x_index -lt ($image.width / $tile_x); $x_index++) { 
        
        # Current position
        $dim = "{0}x{1}+{2}+{3}" -f $tile_x,$tile_y,$x_coord,$y_coord

        # Log what we are doing
        Write-Host "Exporting x${x_index} y${y_index} to ${output_prefix}x${x_index}_y${y_index}.png"

        # Output file
        magick.exe $file -crop $dim "${output_prefix}x${x_index}_y${y_index}.png" # File output name

        # Increment x coordinates
        $x_coord += $tile_x
    }

    # Reset x coord since we are moving from left to right for every 1 y movement
    $x_coord = 0

    # Increment y coordinates
    $y_coord += $tile_y

}